// Testapp_Test_NXAPI.cpp
//

#include "OS_Includes.h"
#include "CifXConsole.h"
#include "netXAPI.h"

#pragma warning(push)
#pragma warning(disable: 4702)
#include <vector>
#pragma warning(pop)

/*****************************************************************************/
/*! Device struct for found device                                           */
/*****************************************************************************/
typedef struct NXAPI_FOUND_DEVICE_Ttag
{
  NXDRV_DEVICE_INFORMATION    tDeviceInfo;    /*!< Device information struct */

} NXAPI_FOUND_DEVICE_T, *PNXAPI_FOUND_DEVICE_T;

typedef std::vector<PNXAPI_FOUND_DEVICE_T> DEVICE_LIST;

/*****************************************************************************/
/*! Print device information                                                 */
/*****************************************************************************/
long PrintFindDeviceInfo(PNXDRV_DEVICE_INFORMATION ptDeviceInfo)
{
 long lRet = NXAPI_NO_ERROR;
  printf("------------------------------------------------\n");
  printf("hDevice               = 0x%08X \r\n", (unsigned long)ptDeviceInfo->hDevice               );
  printf("szDeviceName          = %s     \r\n", ptDeviceInfo->szDeviceName          );
  printf("ulDpmTotalSize        = 0x%08X \r\n", ptDeviceInfo->tSystemInfoBlock.ulDpmTotalSize    );
  printf("ulDeviceNumber        = 0x%08X \r\n", ptDeviceInfo->tSystemInfoBlock.ulDeviceNumber    );
  printf("ulSerialNumber        = 0x%08X \r\n", ptDeviceInfo->tSystemInfoBlock.ulSerialNumber    );
  printf("ausHwOptions[0]       = 0x%04X \r\n", ptDeviceInfo->tSystemInfoBlock.ausHwOptions[0]   );
  printf("ausHwOptions[1]       = 0x%04X \r\n", ptDeviceInfo->tSystemInfoBlock.ausHwOptions[1]   );
  printf("ausHwOptions[2]       = 0x%04X \r\n", ptDeviceInfo->tSystemInfoBlock.ausHwOptions[2]   );
  printf("ausHwOptions[3]       = 0x%04X \r\n", ptDeviceInfo->tSystemInfoBlock.ausHwOptions[3]   );
  printf("usManufacturer        = 0x%04X \r\n", ptDeviceInfo->tSystemInfoBlock.usManufacturer    );
  printf("usProductionDate      = 0x%04X \r\n", ptDeviceInfo->tSystemInfoBlock.usProductionDate  );          
  printf("ulLicenseFlags1       = 0x%08X \r\n", ptDeviceInfo->tSystemInfoBlock.ulLicenseFlags1   );
  printf("ulLicenseFlags2       = 0x%08X \r\n", ptDeviceInfo->tSystemInfoBlock.ulLicenseFlags2   );
  printf("usNetxLicenseID       = 0x%04X \r\n", ptDeviceInfo->tSystemInfoBlock.usNetxLicenseID   );
  printf("usNetxLicenseFlags    = 0x%04X \r\n", ptDeviceInfo->tSystemInfoBlock.usNetxLicenseFlags);
  printf("usDeviceClass         = 0x%04X \r\n", ptDeviceInfo->tSystemInfoBlock.usDeviceClass     );
  printf("bHwRevision           = 0x%02X \r\n", ptDeviceInfo->tSystemInfoBlock.bHwRevision       );
  printf("bHwCompatibility      = 0x%02X \r\n", ptDeviceInfo->tSystemInfoBlock.bHwCompatibility  );
  printf("------------------------------------------------\n");
  printf("\r\n");  


 return lRet;
}

//=============================================================================
// Test NXAPI Download progress callback
//
//
//=============================================================================
long APIENTRY TestnxAPIDownloadProgress(unsigned long ulStep, unsigned long ulMaxStep, void* pvUser, char bFinished, long lError)
{
  UNREFERENCED_PARAMETER(lError);
  UNREFERENCED_PARAMETER(bFinished);
  CONSOLE_SCREEN_BUFFER_INFO* csbiInfo = (CONSOLE_SCREEN_BUFFER_INFO*)pvUser; 
  SetConsoleCursorPosition(GetStdHandle(STD_OUTPUT_HANDLE), csbiInfo->dwCursorPosition);

  if (ulMaxStep>0) 
    printf("%3d%%", ulStep*100/ulMaxStep);

  return CIFX_NO_ERROR;
}

//=============================================================================
// Test NXAPI functionality 
//
//
//=============================================================================
long TestnxAPI( char* pszBoardName, char* pszFullFileName)
      
{
  // Check incomming parameters
  // Check incomming parameters 
  if( (NULL == pszBoardName)    ||
      (NULL == pszFullFileName)  )
      return NXAPI_INVALID_POINTER;

  long lRet = NXAPI_NO_ERROR;

  //------------------------------
  // Load a file
  //------------------------------
  HANDLE hFile = CreateFile(pszFullFileName, 
                            GENERIC_READ,
                            FILE_SHARE_READ,
                            NULL,
                            OPEN_EXISTING,
                            0,
                            NULL);

  if(hFile == INVALID_HANDLE_VALUE)
  {
    // Error opening the file 
    printf("TestNXAPI(): File <%s> open error, LastError: %d\r\n", pszFullFileName, GetLastError());
  } else
  {
    DWORD dwFileSize = GetFileSize(hFile, NULL);
    unsigned char* pabFileData = new unsigned char[dwFileSize];
  
    DWORD dwBytesRead = 0;
    if ( ReadFile(hFile, pabFileData, dwFileSize, &dwBytesRead, NULL) == false)
    {
      // Error opening the file 
      printf("TestNXAPI(): Error reading file <%s>, LastError: %d\r\n", pszFullFileName, GetLastError());
    } else
    {
      //------------------
      // Check nxAPI functions
      //------------------
      printf("\r\n\n");
      printf("Call nxDrvInit... \r\n"); 
      lRet = nxDrvInit();
      ShowError(lRet);

      if(NXAPI_NO_ERROR == lRet)
      {
        unsigned long               ulSearchIdx   = 0;

        // Allocate memory for the device information
        PNXAPI_FOUND_DEVICE_T ptnxFoundDevice = new NXAPI_FOUND_DEVICE_T();                     

        printf("Call nxDrvFindDevice... \r\n"); 
        lRet = nxDrvFindDevice( NXDRV_FIND_FIRST, 
                                sizeof(ptnxFoundDevice->tDeviceInfo), 
                                &ptnxFoundDevice->tDeviceInfo, 
                                (uint32_t*)&ulSearchIdx);
        ShowError(lRet);
  
        if( NXAPI_NO_ERROR == lRet )
        {
          // We got the first device, so search the next one 
          // Print device informations 
          PrintFindDeviceInfo(&ptnxFoundDevice->tDeviceInfo);
          
          // Save device information 
          DEVICE_LIST   cvDeviceList; 

          cvDeviceList.push_back( ptnxFoundDevice);

          while(NXAPI_NO_ERROR == lRet)
          {
            ptnxFoundDevice = new NXAPI_FOUND_DEVICE_T();

            printf("Call nxDrvFindDevice... \r\n"); 
            lRet = nxDrvFindDevice( NXDRV_FIND_NEXT,
                                    sizeof(ptnxFoundDevice->tDeviceInfo), 
                                    &ptnxFoundDevice->tDeviceInfo, 
                                    (uint32_t*)&ulSearchIdx);
            ShowError(lRet);
                                    
            if(NXAPI_NO_ERROR == lRet)
            {
              PrintFindDeviceInfo(&ptnxFoundDevice->tDeviceInfo);
              // Add device information to device list 
              cvDeviceList.push_back( ptnxFoundDevice);
            } else 
            {
              // clean memory for for this device information, cause no device 
              delete ptnxFoundDevice;
            }
          }

          NXDRV_HW_INFORMATION tnxHWInfo = {0};

          printf("\nCall nxDrvGetInformation... \r\n"); 
          lRet = nxDrvGetInformation(sizeof(tnxHWInfo), &tnxHWInfo);
          ShowError(lRet);

          if (NXAPI_NO_ERROR == lRet)
          {
            // Print HW Information
            printf("------------------------------------------------\n");
            printf("szDriverName            = %s     \r\n", tnxHWInfo.szDriverName         );
            printf("szVersion               = %s     \r\n", tnxHWInfo.szVersion            );
            printf("ulDeviceClass           = 0x%08X \r\n", tnxHWInfo.ulDeviceClass        );
            printf("ulDriverRequirements    = 0x%08X \r\n", tnxHWInfo.ulDriverRequirements );
            printf("ulDriverType            = 0x%08X \r\n", tnxHWInfo.ulDriverType         );
            printf("------------------------------------------------\n");
            printf("\r\n");   
          }

          DEVICE_LIST::iterator iterDev = cvDeviceList.begin(); 

          while(iterDev != cvDeviceList.end())
          {
            if ( 0 == strcmp((*iterDev)->tDeviceInfo.szDeviceName, pszBoardName))
              break;
            
            iterDev++;
          }

          if (iterDev != cvDeviceList.end())
          {
            printf("Call nxDrvDownload on %s... \r\n", (*iterDev)->tDeviceInfo.szDeviceName); 
            
            CONSOLE_SCREEN_BUFFER_INFO csbiInfo;
            GetConsoleScreenBufferInfo(GetStdHandle(STD_OUTPUT_HANDLE), &csbiInfo);

            lRet = nxDrvDownload( (*iterDev)->tDeviceInfo.hDevice,
                                  0,
                                  NXAPI_CMD_FIRMWARE,
                                  dwFileSize, 
                                  pszFullFileName, 
                                  pabFileData,
                                  &csbiInfo, 
                                  (PFN_NXAPI_PROGRESS_CALLBACK) TestnxAPIDownloadProgress);
    
            SetConsoleCursorPosition(GetStdHandle(STD_OUTPUT_HANDLE), csbiInfo.dwCursorPosition);
            ShowError(lRet);            
            
            if (lRet == NXAPI_NO_ERROR)
            {
              printf("Call nxDrvStart on %s... \r\n", (*iterDev)->tDeviceInfo.szDeviceName); 
              lRet = nxDrvStart( (*iterDev)->tDeviceInfo.hDevice, 0);
              ShowError(lRet);            
            }
          } else
          {
            printf("Board '%s' not found!\n", pszBoardName);
          }

        }

        // Call nxDrvExit
        lRet = nxDrvExit();
        printf("Call nxDrvExit... ");
        ShowError(lRet);
      }
    }
  }
  return lRet;
}

//=============================================================================
// Test NXAPI Connector Config
//
//
//=============================================================================
void TestConnectorConfig( char* pszBoardName )
{
  long lRet           = NXAPI_NO_ERROR;
  char abTempName[64] = {0}; 
  
  CIFXHANDLE hDriver;
  lRet = xDriverOpen(&hDriver);
  nxDrvInit();
  printf("\n--- NXAPI Connector config test function ---\r\n");
  printf("Call nxConGetCorrespondName Name:%s Cmd: NXCON_GET_FULL_NAME \r\n",pszBoardName);
    
  if( NXAPI_NO_ERROR != ( lRet = nxConGetCorrespondName( pszBoardName, NXCON_GET_SHORT_NAME, sizeof(abTempName), abTempName)))
  {
    printf("- nxConGetCorrespondName returns: 0x%08X \r\n", lRet);
  }else
  {
    printf("- nxConGetCorrespondName was called Name: %s, CorrespondName: %s\r\n\n", pszBoardName, abTempName);
    printf("Call nxConGetCorrespondName Name:%s Cmd: NXCON_GET_SHORT_NAME \r\n", abTempName);
    char abTempShort[32] = {0};
    if( NXAPI_NO_ERROR != ( lRet = nxConGetCorrespondName( abTempName, NXCON_GET_FULL_NAME, sizeof(abTempShort), abTempShort)))
    {
      printf("- nxConGetCorrespondName returns: 0x%08X \r\n", lRet);
    }else
    {
      printf("- nxConGetCorrespondName was called Name: %s, CorrespondName: %s\r\n\n", abTempName, abTempShort);
    }
  }

  std::vector<NXCON_CONNECTOR_INFO_T> cvConnector; 

  // Test find first / find next connector  
  if(CIFX_NO_ERROR == lRet)
  {
    printf("Call nxConEnumerate \r\n");
    
    NXCON_CONNECTOR_INFO_T tConnector = {0};
    
    unsigned long ulConnectorIdx = 0;
    while ( NXAPI_NO_ERROR == (lRet = nxConEnumerate(ulConnectorIdx, sizeof(tConnector), &tConnector)))
    {
      printf("\r\n");
      printf("----------------------------------------------------------------------\r\n");
      printf(" Connector Index        : %u\r\n", ulConnectorIdx);
      printf(" Connector UUID         : %s\r\n", tConnector.szConnectorUUID);
      printf(" Connector FileName:    : %s\r\n", tConnector.szFileName);
      printf(" Connector Identifier   : %s\r\n", tConnector.szIdentifier);
      printf(" Connector Type         : %u\r\n", tConnector.ulConnectorType);
      printf("\r\n");

      // Save found connector
      cvConnector.push_back(tConnector);
      ulConnectorIdx++;
    } 
    // Set error state 
    lRet = NXAPI_NO_ERROR;
  }

  if(NXAPI_NO_ERROR == lRet)
  {
    printf("Call nxConGetConfig\r\n");
     
    NXCON_CONNECTOR_INFO_T tConnector = {0};
    
    
    for(unsigned long ulConnector = 0;
        ulConnector <= cvConnector.size();
        ulConnector++)
    {
      tConnector = cvConnector[ulConnector];
      
      char abTempConfig[1024] = {0};
      unsigned long ulSize = sizeof(abTempConfig);

      if(NXAPI_NO_ERROR == (lRet = nxConGetConfig(tConnector.szConnectorUUID, (uint32_t*)&ulSize, abTempConfig)))
      {
        printf("\r\n");
        printf(" Got Configuration of Connector: %s, Connector Identifier: %s \r\n", tConnector.szFileName, tConnector.szIdentifier);
        printf("----------------------------------------------------------------------\r\n");
        printf(" Connector Configuration: \r\n");
        
        printf(" %s\r\n", abTempConfig);
        printf("\r\n");
      } else
      {
        printf("- nxConGetConfig returns: lRet: 0x%08X \r\n", lRet);
      }

    }
    lRet = NXAPI_NO_ERROR;
  }

  
  if(NXAPI_NO_ERROR == lRet)
  {
    printf("Call nxConSetConfig \r\n");
     
    NXCON_CONNECTOR_INFO_T tConnector = {0};
    
    unsigned long ulConnector = 0;
    tConnector = cvConnector[ulConnector];
      
    std::string szTempConfig("DEVNAME=GLOBAL,ENABLED=0,KEEPALIVETIMEOUT=2000,RESETTIMEOUT=2000;DEVNAME=COM1,BAUDRATE=115200,BYTESIZE=8,PARITY=0,STOPBITS=0;DEVNAME=COM10,BAUDRATE=115200,BYTESIZE=8,PARITY=0,STOPBITS=0;");

    if(NXAPI_NO_ERROR == (lRet = nxConSetConfig(tConnector.szConnectorUUID, (char*) szTempConfig.c_str())))
    {
      printf("\r\n");
      printf(" Set Configuration of Connector: %s, Connector Identifier: %s \r\n", tConnector.szFileName, tConnector.szIdentifier);
      printf("----------------------------------------------------------------------\r\n");
      printf(" Connector Configuration: \r\n");
      printf(" %s\r\n", szTempConfig.c_str());
      printf("\r\n");
    } else
    {
        printf("- nxConSetConfig returns: lRet: 0x%08X \r\n", lRet);
    }

    if(NXAPI_NO_ERROR == lRet)
    {
      ulConnector++;
      tConnector = cvConnector[ulConnector];
      szTempConfig.clear(); 
      szTempConfig.append("DEVNAME=GLOBAL,CONNECTTIMEOUT=1000,ENABLED=1,KEEPALIVETIMEOUT=5000,RESETTIMEOUT=2000;DEVNAME=IF0,IPADDR=192.168.10.50,IPADDREND=,PORT=50111;DEVNAME=IF1,IPADDR=192.168.10.11,IPADDREND=192.168.10.13,PORT=50111;");

      if(NXAPI_NO_ERROR == (lRet = nxConSetConfig(tConnector.szConnectorUUID, (char*)szTempConfig.c_str())))
      {
        printf("\r\n");
        printf(" Set Configuration of Connector: %s, Connector Identifier: %s \r\n", tConnector.szFileName, tConnector.szIdentifier);
        printf("----------------------------------------------------------------------\r\n");
        printf(" Connector Configuration: \r\n");
        printf(" %s\r\n", szTempConfig.c_str());
        printf("\r\n");
      } else
      {
          printf("- nxConSetConfig returns: lRet: 0x%08X \r\n", lRet);
      }
    }
  }
  nxDrvExit();
}

